/*========================================================
 * SD memory card client function for Linux-OS
 *
 * Copyright (c) 2002-2008Matsushita Electric Industrial Co., Ltd.
 * All Rights Reserved.
 * Copyright (c) 2008-2009 Panasonic Corporation
 * All Rights Reserved.
 *
 * Last update: 2009/06/08
 *========================================================*/


/***********************************************************/
/* إåΥ󥯥롼                                    */
/***********************************************************/
/* ̥إå */
#include <sd_api.h>
/* إå */
#include "mem_main.h"

/***********************************************************/
/* block_device_operations¤                           */
/***********************************************************/
static struct block_device_operations SD_MEMORY_fops =
{
	open:				MEMORY_F_Open,
	release:			MEMORY_F_Close,
	ioctl:				MEMORY_F_Ioctl,
	media_changed:		NULL,
	revalidate_disk:	NULL,
};

/***********************************************************/
/* ѥϡɥǥ¤Ρgendisk¤Ρ               */
/***********************************************************/
#define SDMC_CLUSTER_SIZE (16*1024)	//16KByte:FAT16
#if 0
#define UNCACHE 0x20000000
#else
#define UNCACHE 0x00000000
#endif

struct ST_sdmc_mem {
	struct gendisk	*pDisk;
	spinlock_t		lock;
	struct request_queue	*pQueue;
}	sSdmc_mem;
/*-----------------ޤ---------------------*/

char *sdmc_pLocalBuf;
struct semaphore sdmc_rq_sem;       /* ޥե */

/*-----------------ؿ---------------------*/
/***********************************************************/
/* ؿ̾MEMORY_F_Open                                   */
/* ǽ  SDꥫɥ饤ȥɥ饤ФΥץ    */
/*   struct inode *inode ; ǥХݥ  */
/*         struct file  *filp  ; ե빽¤Υݥ    */
/* ͡int ; openؿη̡ʥ꥿      */
/***********************************************************/
static int MEMORY_F_Open(struct block_device *blk, fmode_t f_mode)
{
	int iRet = SD_SUCCESS;
	ULONG wp_check;

	if(!MEMORY_DEV.wp_cnt){
		if(MEMORY_DEV.open_cnt){	// ¿openػ
			iRet = -EALREADY;	// openѤ
			goto fin_open;
		}
		MEMORY_DEV.open_cnt ++;		// open
	}

	/* ե빽¤Τf_mode񤭹߲ǽå */
	/* FMODE_WRITEANDäƥå */
	if( f_mode & FMODE_WRITE ) {
		/* 饤ȥץƥȥåؿcall */
		SD_F_Ioctl(MEMORY_DEV.fd, SD_IOC_GET_WP_CHECK, (ULONG)&wp_check);
		if( wp_check ) {		// ץƥȾ֤
			MEMORY_DEV.wp_cnt ++;	// 󥿥󥯥
			iRet = -EROFS;		// ͥ륨顼
			goto fin_open;		// Open᥽åɽλ
		}
	}

fin_open:
	return iRet;

}


/***********************************************************/
/* ؿ̾MEMORY_F_Close                                  */
/* ǽ  SDꥫɥ饤ȥɥ饤ФΥ    */
/*   struct inode *inode ; ǥХݥ  */
/*         struct file  *filp  ; ե빽¤Υݥ    */
/* ͡SD_SUCCESSɬ                          */
/***********************************************************/
static int MEMORY_F_Close(struct gendisk *gen, fmode_t f_mode)
{

	if(MEMORY_DEV.wp_cnt){
		MEMORY_DEV.wp_cnt --;	// Write Protect󥿥ǥ
	}
	MEMORY_DEV.open_cnt --;	// open

	return SD_SUCCESS;

}


/***********************************************************/
/* ؿ̾MEMORY_F_Request                                */
/* ǽ  ׵Ԥ                                  */
/*   struct request_queue *p ; Ԥ󥭥塼          */
/* ͡Read/Writeֵ͡ʥ꥿        */
/***********************************************************/
static void MEMORY_F_Request(struct request_queue *pReqQue)
{
	UINT32	iRet		= 0;	// 
	ULONG	sector_num;	// Read-Write ϥֹ
	ULONG	sector_count;	// ž׵᥻
	FS_INFO info;	// ž¸Τι¤
	struct	request *req;	// request¤ΤΥݥ(CURRENT)
	int		error;		// end_requestؤΰ(žor)
	struct req_iterator iter;
	struct bio_vec		*psBvec;
	char	*pMapBuf;
	int 	sectors;
	int		totalSect;
	
	spin_unlock_irq(pReqQue->queue_lock);
	down(&sdmc_rq_sem);
	spin_lock_irq(pReqQue->queue_lock);

	req = blk_fetch_request(pReqQue);
	
	while(1)
	{
		if( req == NULL ) {
			up(&sdmc_rq_sem);
			return;
		}
		
		sector_num = blk_rq_pos(req);
		sector_count = blk_rq_sectors(req);

		switch( rq_data_dir(req) )
		{
			case READ:	//ɤ߽Ф
				
				spin_unlock_irq(pReqQue->queue_lock);
				iRet = SD_F_Read( MEMORY_DEV.fd
						, sdmc_pLocalBuf
						, sector_count
						, sector_num
						, SD_NORMAL_AREA
						, &info );
				
				totalSect = 0;
				rq_for_each_segment(psBvec, req, iter)
				{
					sectors = psBvec->bv_len / 512;
					
					pMapBuf = __bio_kmap_atomic( iter.bio, iter.i, KM_USER0 );
	
#ifdef _SDD_PIO_ 
					memcpy( pMapBuf
								, (sdmc_pLocalBuf + (totalSect * 512))
								, (sectors * 512) );
#else 
					memcpy( pMapBuf
								, (sdmc_pLocalBuf + (totalSect * 512) + UNCACHE)
								, (sectors * 512) );
#endif

					__bio_kunmap_atomic( pMapBuf, KM_USER0 );
					totalSect += sectors;
					iter.bio->bi_idx++;
				}
				spin_lock_irq(pReqQue->queue_lock);
				break;
			
			case WRITE:	//񤭹
				
				spin_unlock_irq(pReqQue->queue_lock);
				totalSect = 0;
				rq_for_each_segment(psBvec, req, iter)
				{
					sectors = psBvec->bv_len / 512;
					
					pMapBuf = __bio_kmap_atomic( iter.bio, iter.i, KM_USER0 );
#ifdef _SDD_PIO_
					memcpy( (sdmc_pLocalBuf + (totalSect * 512))
								, pMapBuf
								, (sectors * 512) );
#else
					memcpy( (sdmc_pLocalBuf + (totalSect * 512) + UNCACHE)
								, pMapBuf
								, (sectors * 512) );
#endif

					__bio_kunmap_atomic( pMapBuf, KM_USER0 );
					totalSect += sectors;
					iter.bio->bi_idx++;
				}
				
				iRet = SD_F_Write( MEMORY_DEV.fd
						, sdmc_pLocalBuf
						, sector_count
						, sector_num
						, SD_NORMAL_AREA
						, &info );
				spin_lock_irq(pReqQue->queue_lock);
				break;
			
			default:
				continue;
		}
		
		//end_requestΰ
		if( iRet == 0 ) {
			error = 0;	//
		}else{
			error = -EIO;	//
		}

		if( !__blk_end_request(req, error, (sector_count * 512) ) ) {
			req = blk_fetch_request(pReqQue);
		}
	}
}


/***********************************************************/
/* ؿ̾MEMORY_F_Ioctl                                  */
/* ǽ  ǥХͭ                                */
/*   struct inode  *inode ; ǥХݥ */
/*         struct file   *filp  ; ե빽¤Υݥ   */
/*         unsigned int  cmd    ; 楳               */
/*         unsigned long arg    ; 楳ɰ¸ѥ᡼ */
/* ͡0ʾ                                   */
/***********************************************************/
static int MEMORY_F_Ioctl(struct block_device *dev, fmode_t f_mode, unsigned cmd, unsigned long arg)
{
	return SD_SUCCESS;
}


/***********************************************************/
/* ؿ̾MEMORY_F_Init                                   */
/* ǽ  SDꥫɥ饤ȥɥ饤Фν      */
/*   ʤ                                            */
/* ͡0 -> ｪλ                                   */
/*         ¾ -> 顼                                */
/***********************************************************/
static int MEMORY_F_Init(void)
{
	int iRet = SD_SUCCESS;
	ULONG ulSize;	// ɥǼѿ

	/* Сɽ */
	printk("SD-CS Memory Client Driver : Ver.%02x\n",VERSION_INFO);

	sema_init(&sdmc_rq_sem, 1);

#if 0
	sdmc_pLocalBuf = kmalloc( SDMC_CLUSTER_SIZE, GFP_KERNEL);
	if( sdmc_pLocalBuf == NULL ) {
		return -ENOMEM;
	}
#else
	sdmc_pLocalBuf = kmalloc( SDMC_CLUSTER_SIZE, GFP_DMA);
	if( sdmc_pLocalBuf == NULL ) {
		return -ENOMEM;
	}
#endif
	
	/* MEMORY_DEVФν */
	MEMORY_DEV.open_cnt  = 0;            // ץ󥫥
	MEMORY_DEV.wp_cnt    = 0;            // Write Protectå
	MEMORY_DEV.fd        = 0;            // CSfd

	/* ɥӥɥ饤ФΥץ */
	if(( MEMORY_DEV.fd = SD_F_Open() ) < 0) {	// CSɥ饤 open
		if(sdmc_pLocalBuf != NULL){
			kfree( sdmc_pLocalBuf );
			sdmc_pLocalBuf = NULL;
		}
		return -EALREADY;	// Operation already in progress
	}
	
	//SDꥫɤΥ굡ǽ¤Τ򥯥ꥢ
	memset( &sSdmc_mem, 0, sizeof(struct ST_sdmc_mem) );
	
	//֥åǥХϿ
	iRet = register_blkdev(SD_MEMORY_MAJOR, DEVICE_NAME);
	if (iRet < 0) {
		if(sdmc_pLocalBuf != NULL){
			kfree( sdmc_pLocalBuf );
			sdmc_pLocalBuf = NULL;
		}
		return -ENODEV;	// No such device
	}
	
	//gendisk¤Τ
	sSdmc_mem.pDisk = alloc_disk( SD_MEMORY_MINOR<<MEM_SHIFT );
	if( sSdmc_mem.pDisk == NULL ) {
		goto	F_ERROR_1;
	}
	
	//֥åǥХѤ׵Ԥ
	spin_lock_init( &sSdmc_mem.lock );
	
	//׵׵Ԥ³
	sSdmc_mem.pQueue = blk_init_queue( MEMORY_F_Request, &sSdmc_mem.lock );
	if( !sSdmc_mem.pQueue ) {
		goto	F_ERROR_2;
	}
	
	//׵Ԥ
	blk_queue_max_sectors(sSdmc_mem.pQueue, (SDMC_CLUSTER_SIZE/512));
	
	//gendisk¤Τν
	sSdmc_mem.pDisk->major = SD_MEMORY_MAJOR;
	sSdmc_mem.pDisk->first_minor = 0;
	sprintf( sSdmc_mem.pDisk->disk_name, "sdmc_mem" );
	sSdmc_mem.pDisk->fops = &SD_MEMORY_fops;
	sSdmc_mem.pDisk->queue = sSdmc_mem.pQueue;
	
	//SDΥϿʥ256MByteξ
	SD_F_Ioctl( MEMORY_DEV.fd, SD_IOC_GET_CARDSIZE, (ULONG)&ulSize);
	set_capacity( sSdmc_mem.pDisk, ulSize );
	
	//gendisk򥫡ͥϿ
	add_disk( sSdmc_mem.pDisk );
	
	return 0;
	
F_ERROR_2:
	if(sdmc_pLocalBuf != NULL){
		kfree( sdmc_pLocalBuf );
		sdmc_pLocalBuf = NULL;
	}
	del_gendisk( sSdmc_mem.pDisk );
F_ERROR_1:
#ifdef CONFIG_DEVFS_FS
	devfs_remove( DEVICE_NAME );
#endif	//CONFIG_DEVFS_FS
	unregister_blkdev( SD_MEMORY_MAJOR, DEVICE_NAME );
	
	return -ENOMEM;
}


/***********************************************************/
/* ؿ̾MEMORY_F_Cleanup                                */
/* ǽ  SDꥫɥ饤ȥɥ饤Фνλ    */
/*   ʤ                                            */
/* ͡ʤ                                            */
/***********************************************************/
static void MEMORY_F_Cleanup(void)
{

	/* ɥӥɥ饤ФΥ */
	if(( SD_F_Close(MEMORY_DEV.fd) ) < 0) {	// CSɥ饤 close
		printk("mem_main: SD_F_Close failure\n");
		return;
	}
	
	put_disk( sSdmc_mem.pDisk );
	blk_cleanup_queue( sSdmc_mem.pQueue );
	del_gendisk( sSdmc_mem.pDisk );
	unregister_blkdev( SD_MEMORY_MAJOR, DEVICE_NAME );
	
	if(sdmc_pLocalBuf != NULL){
		kfree( sdmc_pLocalBuf );
		sdmc_pLocalBuf = NULL;
	}
	
	return;

}
/*-----------------ؿޤ---------------------*/


/***********************************************************/
/* ˡ̾̿̾                                    */
/***********************************************************/
module_init(MEMORY_F_Init)
module_exit(MEMORY_F_Cleanup)
MODULE_LICENSE("Proprietary");
